package gov.va.med.domain.service.messaging;

/**
 * @author Slava Uchitel
 * @version $Id: IMessageSender.java,v 1.9 2005/09/20 13:26:55 slava.uchitel Exp $
 * @since MHV 2.0 <br>03/27/2005
 */
public interface IMessageSender
{
    /**
     * Sends the messages by using a TransceiverFacade with encode/decode functionality
     * to decorate the low-level Tansceiver associated with the endPoint.  Normally
     * decoder for this function is an IdentityDecoder because the messages are
     * assumed to be asynchrounous, but this is not required.  If it is a Synchronous
     * message,  the response will be returned after being decoded per the function's
     * decoder.
     * <P>
     * Updates the status of the MessagingRequest if it exists.   
     * <P>
     * @param request contianing the payload, functionName and desinationKey.
     * @return the Response resulting from the send and optional decode
     * @throws MessagingException if any problem occurs in the process
     */
    public Response sendMessage(DestinedRequest request)
            throws MessagingException;
    
    /**
     * Sends the messages synchronously by using a TransceiverFacade with encode/decode functionality
     * to decorate the low-level Tansceiver associated with the endPoint.  Normally
     * decoder for this function is an IdentityDecoder because the messages are
     * assumed to be asynchrounous, but this is not required.  If it is a Synchronous
     * message,  the response will be returned after being decoded per the function's
     * decoder.
     * <P>
     * Updates the status of the MessagingRequest if it exists.   
     * <P>
     * @param request contianing the payload, functionName and desinationKey.
     * @return the Response resulting from the send and optional decode
     */
    public Response sendSynchronousMessage(DestinedRequest request);
    /**
	 * Performs only the transceive with no coupling to the 
	 * MessagingRequest tables. <BR>
	 * The messages are sent using a TransceiverFacade with encode/decode 
	 * functionality to decorate the low-level Tansceiver associated 
	 * with the endPoint.  Normally, the decoder for this function is 
	 * an IdentityDecoder because the messages are
	 * assumed to be asynchrounous, but this is not required.  
	 * If it is a Synchronous message,  the response will be returned 
	 * after being decoded per the function's decoder.
	 * <P>
	 * Traps exceptions and wraps them into error response.
	 * <P>
	 * @param request contianing the payload, functionName and desinationKey.
	 * @return the Response resulting from the send and optional decode
	 */

    public Response transceive(DestinedRequest request) 
    			throws MessagingException;  
    
}